% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{qs}
\alias{arimamodel}
\alias{fivebestmdl}
\alias{qs}
\alias{spc}
\alias{transformfunction}
\title{Diagnostical Statistics}
\usage{
qs(x)

spc(x)

fivebestmdl(x)

arimamodel(x)

transformfunction(x)
}
\arguments{
\item{x}{object of class \code{"seas"}}
}
\value{
\code{qs} returns the QS statistics for seasonality of input and
  output series and the corresponding p-values.

\code{spc} returns the content of the \code{.spc} file, i.e. the
  specification as it is sent to X-13ARIMA-SEATS. Analyzing the \code{spc}
  output is useful for debugging.

\code{fivebestmdl} returns the five best models as chosen by the BIC
  criterion. It needs the \code{automdl} spec to be activated (default). If it is not
  activated, the function tries to re-evaluate the model with
  the \code{automdl} spec activated.

\code{arimamodel} returns the structure of a the ARIMA model, a
  numerical vector of the form \code{(p d q)(P D Q)}, containing the
  non-seasonal and seasonal part of the ARIMA model.

\code{transformfunction} returns the transform function that has been applied.
}
\description{
Functions to access some specific diagnostical statistics in a \code{"seas"} object.
For universal import of X-13ARIMA-SEATS tables, use the \code{\link{series}} function. For
accessing the \code{.out} file of X-13ARIMA-SEATS, use the \code{\link{out}}
function. For diagnostical plots, see \code{\link{plot.seas}}.
}
\examples{
\dontrun{

m <- seas(AirPassengers)

qs(m)
spc(m)
fivebestmdl(m)
arimamodel(m)
transformfunction(m)

# if no automdl spec is present, the model is re-evaluated
m2 <- seas(AirPassengers, arima.model = "(0 1 1)(0 1 1)")
spc(m2)           # arima overwrites the automdl spec
fivebestmdl(m2)   # re-evaluation with automdl

# universal output extraction (see ?series)
series(m, "identify.pacf")

# accessing the .out file (see ?out)
out(m)
}
}
\references{
Vignette with a more detailed description:
  \url{http://cran.r-project.org/web/packages/seasonal/vignettes/seas.pdf}

  Comprehensive list of R examples from the X-13ARIMA-SEATS manual:
  \url{https://github.com/christophsax/seasonal/wiki/Examples-of-X-13ARIMA-SEATS-in-R}

  Official X-13ARIMA-SEATS manual:
  \url{http://www.census.gov/ts/x13as/docX13AS.pdf}
}
\seealso{
\code{\link{seas}} for the main function.

\code{\link{series}}, for universal X-13 output extraction.

\code{\link{plot.seas}}, for diagnostical plots.

\code{\link{out}}, for accessing the full output of X-13ARIMA-SEATS.
}

