% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/import.spc.R
\name{import.spc}
\alias{import.spc}
\alias{print.import.spc}
\title{Import X-13 \code{.spc} Files (experimental)}
\usage{
import.spc(file)

\method{print}{import.spc}(x, ...)
}
\arguments{
\item{file}{character, name of the X-13 \code{.spc} file}

\item{x}{object of class \code{import.spc}}

\item{...}{further arguments, not used}
}
\value{
returns an object of class \code{import.spc}, which is a list with the following (optional) objects of class \code{call}:
  \item{call}{the call to \code{\link{seas}}}
  \item{x}{the call to retrieve the data for the input series}
  \item{xtrans}{the call to retrieve the data for the \code{xtrans} series (if required by the call)}
  \item{xreg}{the call to retrieve the data for the \code{xreg} series (if required by the call)}
}
\description{
Utility function to import \code{.spc}
files from X-13. It generates a list of calls to \code{seas} (and
\code{import.ts}) that can be run in R, which should be
equivalent to the original \code{.spc} file. The print method displays the calls in a way that they can
be copy-pasted into an R script.
}
\examples{
# importing the orginal X-13 example file
import.spc(file.path(path.package("seasonal"), "tests", "Testairline.spc"))

\dontrun{
# a spc with multiple user defined regression and transformation series
tdir <- tempdir()
seas(x = AirPassengers, xreg = cbind(a = genhol(cny, start = 1, end = 4,
    center = "calendar"), b = genhol(cny, start = -3, end = 0,
    center = "calendar")), xtrans = cbind(sqrt(AirPassengers), AirPassengers^3),
    transform.function = "log", transform.type = "temporary",
    regression.aictest = "td", regression.usertype = "holiday", dir = tdir,
    out = TRUE)
ii <- import.spc(file.path(tdir, "iofile.spc"))
ii  # list with 4 calls (3 series import, 1 main call)

# evaluating the imported calls in R
ee <- lapply(ii, eval, envir = globalenv())
ee$call  # the 'seas' object produced from the .spc file
}
}
\seealso{
\code{\link{import.ts}}, for importing X-13 data files.

\code{\link{seas}} for the main function of seasonal.
}

