% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/out.R
\name{out}
\alias{out}
\title{Display X-13ARIMA-SEATS Output}
\usage{
out(x, browser = getOption("browser"), line = 1, n = 100, search = NULL,
  ...)
}
\arguments{
\item{x}{an object of class \code{"seas"}.}

\item{browser}{browser to be used, passed on to
\code{\link{browseURL}} (ignored in the non-HTML version).}

\item{line}{starting line of the content (ignored in the HTML version).}

\item{n}{number of lines to show on a page (ignored in the HTML version).}

\item{search}{regular expression chracter string. If specified, the content
is searched for the first occurence (ignored in the HTML version).}

\item{...}{additional spec-arguments options sent to X-13ARIMA-SEATS during
  re-evaluation. See \code{\link{seas}}.}
}
\value{
displays the output as a side effect.
}
\description{
The \code{out} function shows the full content of the X-13ARIMA-SEATS output.
If you are using the HTML version of X-13 (recommended), the output is
displayed in the browser. If you are using the non-HTML version, the output
is shown in the console.
}
\details{
To keep the size of \code{"seas"} objects small, \code{seas} does not save
the output by default. Instead, \code{out} re-evaluates the model.
}
\examples{
\dontrun{
m <- seas(AirPassengers)
out(m)
out(m, automdl.print = "autochoicemdl")

arguments ignored in the HTML version
out(m, search = "regARIMA model residuals")
out(m, search = "Normality Statistics for regARIMA")
}
}
\references{
Vignette with a more detailed description:
  \url{http://www.seasonal.website/seasonal.html}

  Comprehensive list of R examples from the X-13ARIMA-SEATS manual:
  \url{http://www.seasonal.website/examples.html}


  Official X-13ARIMA-SEATS manual:
  \url{http://www.census.gov/ts/x13as/docX13AS.pdf}
}
\seealso{
\code{\link{seas}} for the main function of seasonal.
}

