% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.check_outliers.R
\name{plot.see_check_outliers}
\alias{plot.see_check_outliers}
\title{Plot method for checking outliers}
\usage{
\method{plot}{see_check_outliers}(x, size_text = 3.5, ...)
}
\arguments{
\item{x}{An object.}

\item{size_text}{Size of text labels.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{performance::check_outliers()} function.
}
\examples{
library(performance)
data(mtcars)
mt1 <- mtcars[, c(1, 3, 4)]
mt2 <- rbind(
  mt1,
  data.frame(mpg = c(37, 40), disp = c(300, 400), hp = c(110, 120))
)
model <- lm(disp ~ mpg + hp, data = mt2)
plot(check_outliers(model))
}
