% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importSBML.R
\name{importSBML}
\alias{importSBML}
\title{Import SBML Models using the Bioconductor package 'rsbml'}
\usage{
importSBML(filename, times, meas_input)
}
\arguments{
\item{filename}{name of the import file. Should be located in the working directory.}

\item{times}{timestep at which the function should be evaluated}

\item{meas_input}{measurements have to be given in order to analyse the data}
}
\value{
returns a odeModel object
}
\description{
A simple function for importing sbml models from a extensive markup language file.
}
\examples{

\donttest{ 

t <- uvbData[,1]
y <- uvbData[,1:3]
modelFile <- system.file("extdata","BIOMD0000000545_url.xml", package = "seeds")

# generate an odeModel object
uvb <- importSBML(modelFile, times = t, meas = y)

}

}
