% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc.R
\name{fastqscreen}
\alias{fastqscreen}
\title{Run FastQ Screen}
\usage{
fastqscreen(
  filepaths,
  outputDir = "fastqscreen_output",
  cmd = "fastq_screen",
  args = c("--threads", foreach::getDoParWorkers(), "--conf",
    "~/FastQ_Screen_Genomes/fastq_screen.conf")
)
}
\arguments{
\item{filepaths}{Paths to fastq files. For single-end reads, each element
should be a single filepath. For paired-end reads, each element can be two
filepaths separated by ";".}

\item{outputDir}{Directory in which to store output. Will be created if it
doesn't exist.}

\item{cmd}{Name or path of the command-line interface.}

\item{args}{Additional arguments to pass to the command-line interface.}
}
\value{
A vector of exit codes, invisibly.
}
\description{
This function calls
\href{https://www.bioinformatics.babraham.ac.uk/projects/fastq_screen/}{fastq_screen}
using \code{\link[=system2]{system2()}}. To run in parallel, register a parallel backend, e.g.,
using \code{\link[doParallel:registerDoParallel]{doParallel::registerDoParallel()}}.
}
\seealso{
\code{\link[=seeker]{seeker()}}
}
