% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kupiec.R
\docType{methods}
\name{kupiec}
\alias{kupiec}
\alias{kupiec-class}
\alias{kupiec-methods}
\alias{kupiec,ANY-method}
\title{Method to backtest VaR violation using the Kupiec statistics}
\usage{
kupiec(y, VaR, VaR_level, verbose = TRUE, test = "PoF")

\S4method{kupiec}{ANY}(y, VaR, VaR_level, verbose = TRUE, test = "PoF")
}
\arguments{
\item{y}{The time series to apply a VaR model (a single asset rerurn or portfolio return).}

\item{VaR}{The forecast VaR.}

\item{VaR_level}{The VaR level, typically 95\% or 99\%.}

\item{verbose}{If \code{TRUE} show the outcome. Default is \code{TRUE}.}

\item{test}{Choose between PoF or TFF. Default is \code{PoF}.}
}
\description{
An S4 method that performs backtest for VaR models using the Kupiec statistics. For a sample of \eqn{n} observations, 
the Kupiec test statistics takes the form of likelihood ratio

\eqn{LR_{PoF}= -2 \log\left(\frac{(1-\alpha)^{T-n_f}\alpha^{n_f}}
                         {\left(1-\frac{n_f}{T}\right)^{T-n_f}\left(\frac{n_f}{T}\right)^{n_f}}\right)}
                         
\eqn{LR_{TFF}= -2 \log\left
 (\frac{\alpha(1-\alpha)^{t_f -1}} {\left ( \frac{1}{t_f}\right
 )\left ( 1- \frac{1}{t_f}\right )^{t_f-1}}\right),
}

where \eqn{n_f} denotes the number of failures occurred and 
\eqn{t_f} the number of days until the first failure within the \eqn{n}
 observations. Under \eqn{H_0}, both \eqn{LR_{PoF}} and \eqn{LR_{TFF}} are asymptotically
\eqn{\chi^2_1}-distributed, and their exceedance of the critical value implies that the VaR model is inadequate.
}
\examples{
pw.CCC.obj = new("simMGarch")
pw.CCC.obj@d = 10
pw.CCC.obj@n = 1000
pw.CCC.obj@changepoints = c(250,750)
pw.CCC.obj = pc_cccsim(pw.CCC.obj)
y_out_of_sample = t(pw.CCC.obj@y[,900:1000])
w=rep(1/pw.CCC.obj@d,pw.CCC.obj@d) #an equally weighted portfolio
#VaR = quantile(t(pw.CCC.obj@y[,1:899])\%*\%w,0.05)
#ts.plot(y_out_of_sample\%*\%w,ylab="portfolio return");abline(h=VaR,col="red")
#kupiec(y_out_of_sample\%*\%w,rep(VaR,100),.95,verbose=TRUE,test="PoF")
}
\references{
Kupiec, P. "Techniques for Verifying the Accuracy of Risk Management Models." Journal of Derivatives. Vol. 3, 1995, pp. 73–84.
}
