% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pc_cccsim.R
\docType{methods}
\name{pc_cccsim-class}
\alias{pc_cccsim-class}
\alias{pc_cccsim}
\alias{pc_cccsim-methods}
\alias{pc_cccsim,simMGarch-method}
\title{A method to simulate nonstationary high-dimensional CCC GARCH models.}
\usage{
pc_cccsim(object)

\S4method{pc_cccsim}{simMGarch}(object)
}
\arguments{
\item{object}{a simMGarch object}
}
\description{
A S4 method that takes as an input a \code{simMGarch} object and outputs a simulated nonstationary CCC model. The formulation of the of the 
piecewise constant CCC model is given in the \code{simMGarch} class.
}
\examples{
pw.CCC.obj <- new("simMGarch")
pw.CCC.obj <- pc_cccsim(pw.CCC.obj)
par(mfrow=c(1,2))
ts.plot(pw.CCC.obj@y[1,],main="a single simulated time series",ylab="series")
ts.plot(pw.CCC.obj@h[1,],main="a single simulated conditional variance",ylab="variance")
}
\references{
Cho, Haeran, and Karolos Korkas. "High-dimensional GARCH process segmentation with an application to Value-at-Risk." arXiv preprint arXiv:1706.01155 (2018).
}
