% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rscripts.R
\name{offspring_gf_2}
\alias{offspring_gf_2}
\title{Calculates offspring genotype frequencies under the two-parameter model.}
\usage{
offspring_gf_2(alpha, xi1, xi2 = xi1, p1, p2)
}
\arguments{
\item{alpha}{The double reduction rate}

\item{xi1}{The preferential pairing parameter of the first parent.}

\item{xi2}{The preferential pairing parameter of the second parent.}

\item{p1}{The first parent's genotype}

\item{p2}{The second parent's genotype}
}
\value{
Offspring genotype frequencies
}
\description{
Calculates offspring genotype frequencies under the two-parameter model.
}
\examples{
alpha <- 1/6
xi1 <- 1/3
xi2 <- 1/3
p1 <- 2
p2 <- 3
offspring_gf_2(alpha = alpha, xi1 = xi1, xi2 = xi2, p1 = p1, p2 = p2)

}
\author{
Mira Thakkar
}
