% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selacSim.R
\name{NucSimulator}
\alias{NucSimulator}
\title{Simulate DNA under General-Time Reversible model}
\usage{
NucSimulator(phy, pars, nsites, nuc.model, base.freqs, ncats)
}
\arguments{
\item{phy}{The phylogenetic tree with branch lengths.}

\item{pars}{A vector of parameters used for the simulation. They are ordered as follows: gamma shape and the rates for the nucleotide model.}

\item{nsites}{The number of sites to simulate.}

\item{nuc.model}{Indicates what type nucleotide model to use. There are three options: "JC", "GTR", or "UNREST".}

\item{base.freqs}{The base frequencies for A C G T (in that order).}

\item{ncats}{The number of discrete gamma categories.}
}
\description{
Simulates nucleotide data based on parameters under the GTR+G model
}
\details{
Simulates a nucleotide matrix using parameters under the GTR+G model. Note that the output can be written to a fasta file using the write.dna() function in the \code{ape} package.
}
\examples{
\donttest{
pp <- SelacOptimize(codon.data.path="FOLDER_WITH_FASTA/", phy=phy, 
	data.type='nucleotide', optimal.aa='none', codon.model='none', nuc.model='GTR', 
	include.gamma=TRUE, gamma.type='quadrature')
sim.dat <- NucSimulator(phy=pp$phy, pars=pp$mle.pars, nsites=pp$nsites, nuc.model=pp$nuc.model)
}
}
