% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elem_filter.R
\name{elem_filter}
\alias{elem_filter}
\alias{elem_find}
\alias{[.selenider_elements}
\alias{[[.selenider_elements}
\title{Extract a subset of HTML elements}
\usage{
elem_filter(x, ...)

elem_find(x, ...)

\method{[}{selenider_elements}(x, i)

\method{[[}{selenider_elements}(x, i)
}
\arguments{
\item{x}{A \code{selenider_elements} object.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Conditions (functions or
function calls) that are used to filter the elements of \code{x}.}

\item{i}{A number (or for \code{[}, a vector of one or more numbers) used to
select elements by position.}
}
\value{
\code{elem_filter()} and \code{[} return a \code{selenider_elements} object, since they can
result in multiple elements.
\code{elem_find()} and \code{[[} return a single \code{selenider_element} object.
}
\description{
Operators to extract a subset of elements, or a single element, from
a selenider element collection.

\code{elem_filter()} and \code{elem_find()} allow you to use conditions to filter HTML
elements (see \code{\link[=is_present]{is_present()}} and other conditions). \code{elem_find()} returns
the \emph{first} element that satisfies one or more conditions, while
\code{elem_filter()} returns every element that satisfies these conditions.

\code{[} and \code{[[} with a numeric subscript can be used on an element collection
to filter the elements by position. \code{[} returns a single element at a
specified location, while \code{[[} returns a collection of the elements at more
than one position.
}
\details{
As with the \code{\link[=find_element]{find_element()}} and \code{\link[=find_elements]{find_elements()}} functions, these
functions are lazy, meaning that the elements are not fetched and filtered
until they are needed.

Conditions can be functions or function calls (see \code{\link[=elem_expect]{elem_expect()}} for more
details).
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<button disabled>Button 1</button>
<button>Button 2</button>
<p>Text</p>
<div style='display:none;'></div>
"
session <- minimal_selenider_session(html)

elements <- ss("*")

# Gives the same result as s()
elements[[1]]

elements[1:3]

elements[-2]

elements |>
  elem_filter(is_visible)

elements |>
  elem_find(is_visible)

# The above is equivalent to:
visible_elems <- elements |>
  elem_filter(is_visible)
visible_elems[[1]]

# In R >= 4.3.0, we can instead do:
# ss(".class1") |>
#   elem_filter(is_visible) |>
#   _[[1]]

ss("button") |>
  elem_filter(is_enabled)

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=find_elements]{find_elements()}} and \code{\link[=ss]{ss()}} to get elements to filter.
\item \code{\link[=is_present]{is_present()}} and other conditions for predicates for HTML elements.
(If you scroll down to the \emph{See also} section, you will find the rest).
}
}
