% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementInteraction.R, R/elementInteractionDoc.R
\name{elementClear}
\alias{elementClear}
\title{Clear an elements text value.}
\usage{
elementClear(webElem, ...)
}
\arguments{
\item{webElem}{An object of class "wElement". A web Element object see \code{\link{wbElement}}.}

\item{...}{Additonal function arguments - Currently passes the \code{\link{retry}} argument.}
}
\value{
invisible(webElem): An object of class "wElement" is invisibly returned.
   A webElement object see \code{\link{wbElement}}. This allows for chaining from this function to
   other functions that take such an object as an argument. See examples for further details.
}
\description{
\code{elementClear} Clear a TEXTAREA or text INPUT element's value.
}
\examples{
\dontrun{
  # start a brower
  remDr <- remoteDr()
  remDr \%>\% go("http://www.google.com/ncr")

  queryBox <- remDr \%>\% findElement("name", "q")

  # send text to the query box
  queryBox \%>\% elementSendKeys("Some ", "text")

  # clear the query box
  queryBox \%>\% elementClear

  # get the search button
  searchBtn <- remDr \%>\% findElement("name", "btnG")
  # send text to query box
  queryBox \%>\% elementSendKeys("R project")

  # click the search button
  searchBtn \%>\% elementClick

  # close browser
  remDr \%>\% deleteSession
}
}
\seealso{
Other elementInteraction functions: \code{\link{elementClick}},
  \code{\link{elementSendKeys}}
}

