% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementState.R, R/elementStateDoc.R
\name{isElementSelected}
\alias{isElementSelected}
\title{Determine if an element is currently selected.}
\usage{
isElementSelected(webElem, ...)
}
\arguments{
\item{webElem}{An object of class "wElement". A web Element object see \code{\link{wbElement}}.}

\item{...}{Additonal function arguments - Currently passes the \code{\link{retry}} argument.}
}
\value{
A logical value is returned indicating whether the elemnent is selected.
}
\description{
\code{isElementSelected} Determines if an OPTION element, or an INPUT element of type checkbox or radiobutton is currently selected.
}
\examples{
\dontrun{
  remDr <- remoteDr()
  remDr \%>\% go("http://www.google.com/ncr")

  # select the search box
  searchElem <- remDr \%>\% findElement("name", "q")

  # get the name of our element
  searchElem \%>\% getElementAttribute("name")

  # get the css background-color
  searchElem \%>\% getElementCssValue("background-color")
  blueScript <- "arguments[0].style.backgroundColor = 'blue';"
  remDr \%>\% executeScript(blueScript, list(searchElem))
  searchElem \%>\% getElementCssValue("background-color")

  # get the javascript property
  # searchElem \%>\% getElementProperty("backgroundColor")

  # get dimensions
  searchElem \%>\% getElementRect

  searchElem \%>\% getElementTagName

  # get some text and return it
  remDr \%>\% go("http://r-project.org")
  remDr \%>\% findElement("css", "h1") \%>\% getElementText

  # close browser
  remDr \%>\% deleteSession
}

}
\seealso{
Other elementState functions: \code{\link{getElementAttribute}},
  \code{\link{getElementCssValue}},
  \code{\link{getElementProperty}},
  \code{\link{getElementRect}},
  \code{\link{getElementTagName}},
  \code{\link{getElementText}},
  \code{\link{isElementEnabled}}
}

