% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/selfea.R
\name{top_table}
\alias{top_table}
\title{top_table}
\usage{
top_table(input_list, pvalue = 0.05, power_desired = 0.84, method = "QPF",
  FC_threshold = 2)
}
\arguments{
\item{input_list}{The list produced by 'get_statistics_from_file' or 'get_statistics_from_dataFrame' function.
See \code{\link{get_statistics_from_file}} and \code{\link{get_statistics_from_dataFrame}} for more information.
It consists of the following items:
\tabular{ll}{
    $data_table \tab A data frame that consists of ID, GLM Negative Binomial P-value, Cohen's W, GLM Quasi-Poisson P-value, ANOVA with Normal P-value and Cohen's f. \cr
    $min_rep \tab Common number of replicates in your group information.  Generally, it is the minimum number of replicates. \cr
    $max_rep \tab Maximum number of replicates in your group information. \cr
    $nt \tab The number of total experiments in your expression profile. \cr
    $ng \tab The number of groups in your group information. \cr
}}

\item{pvalue}{p-value should be ranged between 0 to 1.
default is 0.05.}

\item{power_desired}{Give the statistical power you desired for output significant list}

\item{method}{Choose statistics method you want to use for making significant list
\tabular{lll}{
1 \tab "QPF" \tab combination of Quasi-Poisson and Cohen's f. Default. \cr
2 \tab "QPFC" \tab combination of Quasi-Poisson and Fold change. \cr
3 \tab "NBW" \tab combination of Negative Binomial and Cohen's w. \cr
4 \tab "NBFC" \tab combination of Negative Binomial and Fold change. \cr
5 \tab "NORF" \tab combination of ANOVA with normal distribution and Cohen's f. \cr
6 \tab "NORFC" \tab combination of ANOVA with normal distribution and Fold change. \cr
}}

\item{FC_threshold}{Fold change you want to use. Default is 2.}
}
\value{
A list containing the follow items.
   \tabular{ll}{
   top_table \tab a data frame that consists of ID, Cohen's W, Cohen's F, Max fold change, GLM Negative Binomial P-value, GLM Quasi-Poisson P-value and ANOVA with Normal P-value \cr
   minimum_cohen_f \tab Minimum Cohen's f found in the top_table \cr
   minimum_cohen_w \tab Minimum Cohen's w found in the top_table \cr
   minimum_power \tab Minimum statistical power calculated from hypothsis tested for the top_table's entities \cr
   alpha \tab Maximum adjusted p-value \cr
   num_group \tab The number of groups used for generating the top_table \cr
   num_columns \tab The number of columns (samples or experiments) \cr
   common_replicates \tab The number of common replicates. \cr
   minimum_FC \tab Minimum fold change that was used to generate top_table \cr
   }
}
\description{
Get IDs that pass two filters, p-value and effect-size.  This top_table will make a significant list that is less than p-value and greater than effect-size.  Effect-size are calculated by obtained power level.
   This function requires four parameters. ex) top_table(input_data,pvalue=0.05,power_desired=0.84,method='QPF')
}
\examples{
library(selfea)

## For this example we will import Gregori data
## Josep Gregori, Laura Villareal, Alex Sanchez, Jose Baselga, Josep Villanueva (2013).
## An Effect Size Filter Improves the Reproducibility
## in Spectral Counting-based Comparative Proteomics.
## Journal of Proteomics, DOI http://dx.doi.org/10.1016/j.jprot.2013.05.030')

## Description:
## Each sample consists in 500ng of standard yeast lisate spiked with
## 100, 200, 400 and 600fm of a mix of 48 equimolar human proteins (UPS1, Sigma-Aldrich).
## The dataset contains a different number of technical replimessagees of each sample

## import Gregori data
data(example_data1)
df_contrast <- example_data
df_group <- example_group

## Get statistics through 'get_statistics_from_dataFrame' function
list_result <- get_statistics_from_dataFrame(df_contrast,df_group)

## Get significant features (alpha >= 0.05 and power >= 0.84)
significant_qpf <- top_table(list_result,pvalue=0.05,power_desired=0.84,method='QPF')
}

