% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{getPsi.B}
\alias{getPsi.B}
\title{getPsi.B}
\usage{
getPsi.B(B, sPsi = NULL, standResCov = TRUE)
}
\arguments{
\item{B}{matrix of regression coefficients (all-y notation). May only contain non-zero values either above or below the diagonal.}

\item{sPsi}{matrix of (residual) correlations/covariances. This is not the Psi matrix, but defines the desired correlations/covariances beyond those implied by B. Can be NULL for no correlations. Standardized and unstandardized residual covariances (between endogenous variables) cannot have the same value, so \code{standResCov} defines whether to treat these as unstandardized or as standardized.}

\item{standResCov}{whether elements in \code{sPsi} referring to residual covariances (between endogenous variables) shall treated as correlation or as covariance.}
}
\value{
Psi
}
\description{
Computes the implied Psi matrix from Beta, when all coefficients in Beta should be standardized.
}
\examples{
\dontrun{
# mediation model
B <- matrix(c(
  c(.00, .00, .00),
  c(.10, .00, .00),
  c(.20, .30, .00)
), byrow = TRUE, ncol = 3)
Psi <- getPsi.B(B)

# CLPM with residual correlations 
B <- matrix(c(
  c(.00, .00, .00, .00),
  c(.30, .00, .00, .00),
  c(.70, .10, .00, .00),
  c(.20, .70, .00, .00)
), byrow = TRUE, ncol = 4)
sPsi <- matrix(c(
  c(1, .00, .00, .00),
  c(.00, 1, .00, .00),
  c(.00, .00, 1, .30),
  c(.00, .00, .30, 1)
), byrow = TRUE, ncol = 4)
# so that residual cor is std
Psi <- getPsi.B(B, sPsi, standResCov = TRUE)
# so that residual cor is unsstd
Psi <- getPsi.B(B, sPsi, standResCov = FALSE)
}
}
