% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/menu_item.R
\name{menu_item}
\alias{menu_item}
\alias{menuItem}
\alias{menuSubItem}
\title{Create a menu item.}
\usage{
menu_item(text, ..., icon = NULL, tabName = NULL, href = NULL, newtab = TRUE)

menuItem(text, ..., icon = NULL, tabName = NULL, href = NULL, newtab = TRUE)

menuSubItem(text, ..., icon = NULL, tabName = NULL, href = NULL, newtab = TRUE)
}
\arguments{
\item{text}{Text to show for the menu item.}

\item{...}{This may consist of menuSubItems.}

\item{icon}{Icon of the menu item. (Optional)}

\item{tabName}{Id of the tab. Not compatible with href.}

\item{href}{A link address. Not compatible with tabName.}

\item{newtab}{If href is supplied, should the link open in a new browser tab?}
}
\value{
A menu item that can be passed \code{\link[semantic.dashboard]{sidebarMenu}}
}
\description{
Create a menu item corresponding to a tab.
}
\section{Functions}{
\itemize{
\item \code{menuItem}: Create a menu item (alias for \code{manu_item} for compatibility with \code{shinydashboard})

\item \code{menuSubItem}: Create a menu item (alias for \code{manu_item} for compatibility with \code{shinydashboard})
}}

\examples{
menuItem(tabName = "plot_tab", text = "My plot", icon = icon("home"))
}
