% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semantic_dashboard.R
\name{dashboard_body}
\alias{dashboard_body}
\alias{dashboardBody}
\title{Create a body of a dashboard.}
\usage{
dashboard_body(...)

dashboardBody(...)
}
\arguments{
\item{...}{UI elements to include within the body.}
}
\value{
A tab that can be passed to \code{\link[semantic.dashboard]{dashboardPage}}
}
\description{
Create a body of a dashboard with tabs and other additional UI elements.
}
\section{Functions}{
\itemize{
\item \code{dashboardBody}: Create a body of a dashboard (alias for \code{dashboard_body} for compatibility with \code{shinydashboard})
}}

\examples{
if(interactive()){

  library(shiny)
  library(semantic.dashboard)

  ui <- dashboardPage(
    dashboardHeader(color = "blue"),
    dashboardSidebar(side = "left", size = "thin", color = "teal",
                     sidebarMenu(
                       menuItem(tabName = "tab1", "Tab 1"),
                       menuItem(tabName = "tab2", "Tab 2"))),
    dashboardBody(tabItems(
      tabItem(tabName = "tab1", p("Tab 1")),
      tabItem(tabName = "tab2", p("Tab 2"))))
  )

  server <- function(input, output) {
  }

  shinyApp(ui, server)
}
}
