% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_est_change.R
\name{print.est_change}
\alias{print.est_change}
\title{Print an 'est_change' Class Object}
\usage{
\method{print}{est_change}(x, digits = 3, first = 10, sort_by = c("gcd", "est"), ...)
}
\arguments{
\item{x}{An 'est_change'-class object.}

\item{digits}{The number of digits after the decimal.
Default is 3.}

\item{first}{Numeric. If not \code{NULL}, it prints
only the first \emph{k} cases, \emph{k} equal to \code{first}.
Default is 10.}

\item{sort_by}{String. Should be \code{"est"}, \code{"gcd"},
or \code{NULL}.
If the output was generated
by \code{\link[=est_change_raw]{est_change_raw()}}
or \code{\link[=est_change_raw_approx]{est_change_raw_approx()}} and \code{sort_by} is
not \code{NULL}, then
each column is sorted individually, with case IDs inserted
before each column. If the output was generated by
\code{\link[=est_change]{est_change()}} or \code{\link[=est_change_approx]{est_change_approx()}} and \code{sort_by}
is not \code{NULL}, then \code{sort_by} determines how the cases are sorted.
If \code{by} is \code{"est"}, the cases are sorted as for
the output of \code{\link[=est_change_raw]{est_change_raw()}}. If \code{by} is \code{"gcd"},
the default for the output of \code{\link[=est_change]{est_change()}} or
\code{\link[=est_change_approx]{est_change_approx()}},
then cases are sorted by generalized Cook's distance
or approximate generalized Cook's distance, depending on
which column is available.}

\item{...}{Other arguments. They will be ignored.}
}
\value{
\code{x} is returned invisibly. Called for its side effect.
}
\description{
Print the content of an 'est_change'-class object.
}
\details{
All the functions on case influence
on parameter estimates, \code{\link[=est_change]{est_change()}},
\code{\link[=est_change_approx]{est_change_approx()}}, \code{\link[=est_change_raw]{est_change_raw()}},
and \code{\link[=est_change_raw_approx]{est_change_raw_approx()}}, return
an \code{est_change}-class object. This method will print
the output based on the type of changes and method
used.
}
\examples{

library(lavaan)

# A path model

dat <- pa_dat
mod <-
"
m1 ~ a1 * iv1 + a2 * iv2
dv ~ b * m1
a1b := a1 * b
a2b := a2 * b
"
# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)

# Approximate case influence
out <- est_change_approx(fit)
out
print(out, sort_by = "est")
out <- est_change_raw_approx(fit)
print(out, first = 3)

# Examine four selected cases
fit_rerun <- lavaan_rerun(fit, parallel = FALSE,
                          to_rerun = c(2, 3, 5, 7))
est_change(fit_rerun)
est_change_raw(fit_rerun)

}
\seealso{
\code{\link[=est_change_raw]{est_change_raw()}}, \code{\link[=est_change_raw_approx]{est_change_raw_approx()}},
\code{\link[=est_change]{est_change()}}, \code{\link[=est_change_approx]{est_change_approx()}}
}
