% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitMeasures_by_models.R
\name{fitMeasures_by_models}
\alias{fitMeasures_by_models}
\title{Fit Measures By Models}
\usage{
fitMeasures_by_models(object_list, ...)
}
\arguments{
\item{object_list}{A named list of
\linkS4class{lavaan} objects.}

\item{...}{Optional arguments to be
passed to
\code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}}.}
}
\value{
A data-frame-like object of
the class \code{fit_by_models}, which
has a \code{print} method (see
\code{\link[=print.fit_by_models]{print.fit_by_models()}}).
}
\description{
Groups fit measures
into a table with models as columns.
}
\details{
It call \code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}} to
compute for each model the fit
measures supported by \code{lavaan}, and
combine them into a data frame. Users
can then use the print method
(\code{\link[=print.fit_by_models]{print.fit_by_models()}}) to customize
the printout.

To be consist with full \code{lavaan}
output, the names used in
\code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}} are used.

This function is intended for
a simple and compact table of
fit measures for quick preview.
For a well-organized
layout, call \code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}}
and set \code{output} to \code{"text"}.
}
\examples{

library(lavaan)
set.seed(5478374)
n <- 50
x <- runif(n) - .5
m <- .40 * x + rnorm(n, 0, sqrt(1 - .40))
y <- .30 * m + rnorm(n, 0, sqrt(1 - .30))
dat <- data.frame(x = x, y = y, m = m)
model1 <-
'
m ~ a*x
y ~ b*m
ab := a*b
'
fit1 <- sem(model1, data = dat, fixed.x = FALSE)
model2 <-
'
m ~ a*x
y ~ b*m + x
ab := a*b
'
fit2 <- sem(model2, data = dat, fixed.x = FALSE)

fitMeasures_by_models(list(no_direct = fit1,
                           direct = fit2))

}
\seealso{
\code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}}
}
\author{
Shu Fai Cheung
\url{https://orcid.org/0000-0002-9871-9448}.
}
