% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projpar.R
\name{projpar}
\alias{projpar}
\alias{projname}
\title{Return a parameter used in a WRT projection}
\usage{
projpar(proj4string, par, abort = FALSE)

projname(proj4string, abort = FALSE)
}
\arguments{
\item{proj4string}{The proj4string to be named.}

\item{par}{Character corresponding to the parameter name.}

\item{abort}{logical: if TRUE, the function aborts in case an invalid
proj4string is passed; if FALSE (default), the function returns NA,
and a warning is shown.}
}
\value{
A character with the content of the parameter (NULL if the
parameter is not recognised) or the name of the projection, and an
attribute \code{proj4string} with the input projection checked using
\code{\link[sf:st_crs]{sf::st_crs()}}.
}
\description{
Return the value of a parameter (or the name) present in
the WKT of the given proj4string.
}
\note{
Python is needed.
}
\examples{
\donttest{
projpar("+init=epsg:4326", "Unit")
}
\donttest{
projname("+init=epsg:4326")
}
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
