% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_crs2.R
\name{st_crs2}
\alias{st_crs2}
\title{Retrieve coordinate reference system from sf or sfc object}
\usage{
st_crs2(x, ...)
}
\arguments{
\item{x}{numeric, character, or object of class \link{sf} or \link{sfc}}

\item{...}{other parameters passed to \link[sf:st_crs]{sf::st_crs}.}
}
\value{
If \code{x} is 0 < numeric <= 60, return \code{crs} object for UTM timezone \code{x} N;
if \code{x} is numeric > 60, return \code{crs} object for SRID \code{x};
if \code{x} is character in the form \code{nn}, \code{nnN} or \code{nnS}, being \code{nn} a number 0 < nn <= 60,
return \code{crs} object for UTM timezone \code{x} N or \code{x} S (N if not specified);
if \code{x} is a different character, return \code{crs} object for proj4string \code{x};
if \code{wkt} is given, return \code{crs} object for well-known-text representation \code{wkt};
if \code{x} is of class \code{sf} or \code{sfc}, return its \code{crs} object.
}
\description{
This function is a wrapper for \link[sf:st_crs]{sf::st_crs}, unless accepting
also UTM timezones (see details) and threating numeric \code{character} strings
as integers.
}
\details{
See \link[sf:st_crs]{sf::st_crs} for details.
}
\note{
License: GPL 3.0
}
\examples{
st_crs2("+init=epsg:32609")
st_crs2(32609)
st_crs2(9)
st_crs2("09")
st_crs2("9N")
st_crs2("09S")
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
