% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_pad2.R
\name{str_pad2}
\alias{str_pad2}
\title{Pad a string.}
\usage{
str_pad2(string, width, side = c("left", "right", "both"), pad = " ")
}
\arguments{
\item{string}{A character vector.}

\item{width}{Minimum width of padded strings.}

\item{side}{Side on which padding character is added (left, right or both).}

\item{pad}{Single padding character (default is a space).}
}
\value{
A character vector.
}
\description{
Vectorised over \code{string}, \code{width} and \code{pad}.
This is an internal function doing the same thing of \code{str_pad()}
function in package \code{stringr}
(except for parameters \code{'width'} and \code{'length'} which must be of length 1),
but without depending on package \code{stringi}.
}
\note{
License: GPL 3.0
}
\examples{
rbind(
  str_pad2("hadley", 30, "left"),
  str_pad2("hadley", 30, "right"),
  str_pad2("hadley", 30, "both")
)

# All arguments are vectorised except side
str_pad2(c("a", "abc", "abcdef"), 10)

# Longer strings are returned unchanged
str_pad2("hadley", 3)
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473. DOI:
\href{https://doi.org/10.1016/j.cageo.2020.104473}{10.1016/j.cageo.2020.104473},
URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
