% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_gcloud.R
\name{check_gcloud}
\alias{check_gcloud}
\alias{is_gcloud_configured}
\alias{check_gcloud_connection}
\title{Check Google Cloud SDK installation}
\usage{
check_gcloud(
  gsutil_dir,
  force = FALSE,
  full_scan = FALSE,
  abort = TRUE,
  check_creds = TRUE
)

is_gcloud_configured()

check_gcloud_connection()
}
\arguments{
\item{gsutil_dir}{(optional) Character: the path of the \code{gsutil} executable,
or the directory in which it is installed.
If not provided, \code{gsutil} is searched in the system path.}

\item{force}{(optional) Logical: if TRUE, check even if it is already
configured (default is FALSE).}

\item{full_scan}{(optional) Logical: in Linux and MacOS, if \code{gsutil_dir} was
not manually defined, \code{gsutil} is searched within the system path in case this
argument is left to default value FALSE; instead, if TRUE, a full search is
performed. In Windows, if the folder \verb{Google\\Cloud SDK} exist in
\verb{C:\\Program Files (x86)}, \verb{C:\\Program Files} or
\verb{C:\\Users\\<username>\\AppData\\Local}, then \code{gsutil} is searched there, otherwise in the main
directory \verb{C:\\}; setting \code{full_scan = TRUE}, is is always searched
in the whole \verb{C:\\}.
This argument takes no effect if \code{gsutil_dir} was defined, since, in that case,
a full search is always performed in \code{gsutil_dir}.}

\item{abort}{(optional) Logical: if TRUE (default), the function aborts
in case no Google Cloud SDK installation is found; if FALSE,
a warning is shown and FALSE is returned.}

\item{check_creds}{(optional) Logical: if TRUE, check also if a user account
(required to search and download products) was set.}
}
\value{
\code{check_gcloud()} returns TRUE (invisible) in case Google Cloud SDK
was correctly set, FALSE if it was not found, not configured
(if \code{check_creds = TRUE}) and \code{abort = FALSE} (otherwise, the function stops).

\code{is_gcloud_configured()} returns TRUE if Google Cloud SDK is installed
and an account is configured, FALSE if not.

\code{check_gcloud_connection()} returns TRUE if connection
is available, FALSE otherwise.
}
\description{
Google Cloud SDK is an optional dependency, required to search and download
SAFE archives from Google Cloud.

\code{check_gcloud()} checks if Google Cloud SDK is externally
installed and if a user account is set.

\code{is_gcloud_configured()} check if Google Cloud SDK were already
configured in sen2r using \code{check_gcloud()}.

\code{check_gcloud_connection()} check if internet connection
is available and Sentinel-2 bucket is accessible on Google Cloud.
}
\note{
License: GPL 3.0
}
\examples{
\dontrun{
check_gcloud()
check_gcloud_connection()
}
\donttest{
is_gcloud_configured()
}
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2021)
}
