% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_param_list.R
\name{check_param_list}
\alias{check_param_list}
\title{Check a parameter list}
\usage{
check_param_list(pm, type = "string", check_paths = FALSE, correct = TRUE)
}
\arguments{
\item{pm}{List of parameters or path of a JSON parameter file.}

\item{type}{Type of the output (see \link{print_message} for details).}

\item{check_paths}{Logical: if TRUE, the function checks required output
paths to be provided; if FALSE (default) these checks are skipped.}

\item{correct}{Logical: if TRUE (default), the function corrects
some incoherences (e.g. timewindow of length 1 is transformed in length 2)
and returns the corrected list as output; if false, only checking is
performed, and the output is NULL if no errors occur.}
}
\value{
In case of errors, depending on \code{type} argument, output can be
a vector of errors (if \code{type = "string"}),
the first error occurred (if \code{type = "error"})
or a set of warnings (if \code{type = "warning"}).
If no errors occur, output is the corrected parameter list if
\code{correct = TRUE} or NULL otherwise.
}
\description{
Check that the parameter list (or JSON parameter file)
is in the correct format, and then specified values are coherent with
parameters.
}
\note{
License: GPL 3.0
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019)
}
\keyword{internal}
