% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_message.R
\name{print_message}
\alias{print_message}
\title{Print a message}
\usage{
print_message(
  ...,
  type,
  sep = "",
  date = FALSE,
  date_format = "",
  width = 0.9 * getOption("width"),
  indent = TRUE,
  exdent = TRUE,
  prefix = "",
  initial = prefix
)
}
\arguments{
\item{...}{\code{R} objects which are concatenated.}

\item{type}{Type of the output .Accepted values:
\itemize{
\item 'message' for a diagnostic message;
\item 'string' for a character output;
\item 'cat' for the output of \code{cat()} function;
\item 'error' and 'warning' for an error or warning message.
}

Intentionally, no default value is defined.}

\item{sep}{(optional) character used to separate input values
(default is nothing).}

\item{date}{Logical value: set \code{TRUE} to place the date before the message
and after the prefix (this is useful for logs or time consuming operations);
default is FALSE.}

\item{date_format}{Format of the date (see \code{strftime()})
for the definition of the format). The default format is
\code{'\\\%Y-\\\%m-\\\%d \\\%H:\\\%M:\\\%S'}.}

\item{width}{Positive integer: target column for wrapping lines in the output
(set to \code{Inf} for no wrapping).}

\item{indent}{Non-negative integer: indentation of the first line in a paragraph
It can be also a logical: in this case, if TRUE (default) the value
is optimised in order to align first line with the followings.}

\item{exdent}{Non-negative integer: indentation of subsequent lines in paragraphs.
It can be also a logical: in this case, if TRUE (default) the value
is optimised in order to align lines with the first line.}

\item{prefix}{Character: prefix for each line except the first.}

\item{initial}{Character: prefix for the first line.}
}
\value{
Message (in the defined format).
}
\description{
A common interface for printing messages of several types.
}
\details{
Several functions print messages in different formats
(message, error, warning, cat, R output) and with different syntaxes
(concatenating parameters or accepting a single argument, appending
a new line, etc.).
This accessory function provides a common interface for different types:
several arguments are accepted and concatenated with the \code{sep} argument;
the format is defined with the \code{format} argument; a date is optionally
placed before the message.
}
\note{
License: GPL 3.0
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2020)
}
\keyword{internal}
