% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovb_plots.R
\name{ovb_extreme_plot}
\alias{ovb_extreme_plot}
\alias{ovb_extreme_plot.lm}
\alias{ovb_extreme_plot.formula}
\alias{ovb_extreme_plot.numeric}
\title{Extreme scenarios plots of omitted variable bias}
\usage{
ovb_extreme_plot(...)

\method{ovb_extreme_plot}{lm}(model, treatment,
  benchmark_covariates = NULL, kd = 1, r2yz.dx = c(1, 0.75, 0.5),
  r2dz.x = NULL, reduce = TRUE, threshold = 0, lim = min(c(r2dz.x +
  0.1, 0.5)), legend = TRUE, cex.legend = 0.5, legend.bty = "o", ...)

\method{ovb_extreme_plot}{formula}(formula, data, treatment,
  benchmark_covariates = NULL, kd = 1, r2yz.dx = c(1, 0.75, 0.5),
  r2dz.x = NULL, reduce = TRUE, threshold = 0, lim = min(c(r2dz.x +
  0.1, 0.5)), legend = TRUE, cex.legend = 0.5, legend.bty = "o", ...)

\method{ovb_extreme_plot}{numeric}(estimate, se, dof, r2dz.x = NULL,
  r2yz.dx = c(1, 0.75, 0.5), reduce = TRUE, threshold = 0,
  lim = min(c(r2dz.x + 0.1, 0.5)), legend = TRUE, cex.legend = 0.5,
  legend.bty = "o", ...)
}
\arguments{
\item{...}{arguments passed to other methods. First argument should either be an \code{\link{lm}} model with the
outcome regression, a \code{\link{formula}} describing the model along
with the \code{\link{data.frame}} containing the variables of the model,
or a numeric vector with the coefficient estimate.}

\item{model}{An \code{lm} object with the outcome regression.}

\item{treatment}{A character vector with the name of the treatment variable
of the model.}

\item{benchmark_covariates}{a character vector of the names of covariates that will be used to bound the plausible strength
of the unobserved confounders.}

\item{kd}{numeric vector. Parameterizes how many times stronger the confounder is related to the treatment in comparison to the observed benchmark covariate.
Default value is \code{1} (confounder is as strong as benchmark covariate).}

\item{r2yz.dx}{Hypothetical partial R2 of unobserved confounder Z
with outcome Y, given covariates X and treatment D.}

\item{r2dz.x}{Hypothetical partial R2 of unobserved confounder
Z with treatment D, given covariates X.}

\item{reduce}{Should the bias adjustment reduce or increase the
absolute value of the estimated coefficient? Default is \code{TRUE}.}

\item{threshold}{estimate threshold.}

\item{lim}{sets limit of the plot.}

\item{legend}{should legend be plotted? Default is \code{TRUE}.}

\item{cex.legend}{size of the text for the legend.}

\item{legend.bty}{legend box. See \code{bty} argument of \link{par}.}

\item{formula}{an object of the class \code{\link{formula}}: a symbolic description of the model to be fitted.}

\item{data}{data needed only when you pass a formula as first parameter. An object of the class \code{\link{data.frame}} containing the variables used in the analysis.}

\item{estimate}{Coefficient estimate.}

\item{se}{Standard error of the coefficient estimate.}

\item{dof}{Residual degrees of freedom of the regression.}
}
\value{
The function returns invisibly the data used for the extreme plot.
}
\description{
Extreme scenario plots of omitted variable bias for sensitivity analysis. The main inputs are an \code{\link{lm}} model, the treatment variable
and the covariates used for benchmarking the strength of unobserved confounding.

The horizontal axis shows the partial R2 of the unobserved confounder(s) with the treatment. The vertical axis shows the adjusted treatment effect estimate.
The partial R2 of the confounder with the outcome is represented by \emph{different curves} for each scenario, as given by the parameter \code{r2yz.dx}.
The red marks on horizontal axis are bounds on the partial R2 of the unobserved confounder \code{kd} times as strong as the covariates used for benchmarking.
The dotted red line represent the threshold for the effect estimate deemed to be problematic (for instance, zero).

See Cinelli and Hazlett (2018) for details.
}
\examples{

# runs regression model
model <- lm(peacefactor ~ directlyharmed + age + farmer_dar + herder_dar +
                         pastvoted + hhsize_darfur + female + village,
                         data = darfur)
# extreme scenarios plot
ovb_extreme_plot(model, treatment = "directlyharmed",
                        benchmark_covariates = "female",
                        kd = 1:2,
                        lim = 0.05)

}
\references{
Cinelli, C. and Hazlett, C. "Making Sense of Sensitivity: Extending Omitted Variable Bias." (2018).
}
