% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influ_phylm.R
\name{influ_phylm}
\alias{influ_phylm}
\title{Influential species detection - Phylogenetic Linear Regression}
\usage{
influ_phylm(formula, data, phy, model = "lambda", cutoff = 2,
  track = TRUE, ...)
}
\arguments{
\item{formula}{The model formula}

\item{data}{Data frame containing species traits with row names matching tips
in \code{phy}.}

\item{phy}{A phylogeny (class 'phylo') matching \code{data}.}

\item{model}{The phylogenetic model to use (see Details). Default is \code{lambda}.}

\item{cutoff}{The cutoff value used to identify for influential species
(see Details)}

\item{track}{Print a report tracking function progress (default = TRUE)}

\item{...}{Further arguments to be passed to \code{phylolm}}
}
\value{
The function \code{influ_phylm} returns a list with the following
components:

\code{cutoff}: The value selected for \code{cutoff}

\code{formula}: The formula

\code{full.model.estimates}: Coefficients, aic and the optimised
value of the phylogenetic parameter (e.g. \code{lambda}) for the full model
without deleted species.

\code{influential_species}: List of influential species, both
based on standardised difference in interecept and in the slope of the
regression. Species are ordered from most influential to less influential and
only include species with a standardised difference > \code{cutoff}.

\code{influ.model.estimates}: A data frame with all simulation
estimates. Each row represents a deleted clade. #' Columns report the calculated
regression intercept (\code{intercept}), difference between simulation
intercept and full model intercept (\code{DFintercept}), the standardised
difference (\code{sDFintercept}), the percentage of change in intercept compared
to the full model (\code{intercept.perc}) and intercept p-value
(\code{pval.intercept}). All these parameters are also reported for the regression
slope (\code{DFslope} etc.). Additionally, model aic value (\code{AIC}) and
the optimised value (\code{optpar}) of the phylogenetic parameter
(e.g. \code{kappa} or \code{lambda}, depending on the phylogenetic model used) are
reported.

\code{data}: Original full dataset.

\code{errors}: Species where deletion resulted in errors.
}
\description{
Performs leave-one-out deletion analyis for phylogenetic linear regression,
and detects influential species.
}
\details{
This function sequentially removes one species at a time, fits a phylogenetic
linear regression model using \code{\link[phylolm]{phylolm}}, stores the
results and detects influential species.

All phylogenetic models from \code{phylolm} can be used, i.e. \code{BM},
\code{OUfixedRoot}, \code{OUrandomRoot}, \code{lambda}, \code{kappa},
\code{delta}, \code{EB} and \code{trend}. See ?\code{phylolm} for details.

\code{influ_phylm} detects influential species based on the standardised
difference in intercept and/or slope when removing a given species compared
to the full model including all species. Species with a standardised difference
above the value of \code{cutoff} are identified as influential. The default
value for the cutoff is 2 standardised differences change.

Currently, this function can only implement simple linear models (i.e. \eqn{trait~
predictor}). In the future we will implement more complex models.

Output can be visualised using \code{sensi_plot}.
}
\examples{
# Load data:
data(alien)
# run analysis:
influ <- influ_phylm(log(gestaLen) ~ log(adultMass), phy = alien$phy[[1]], 
data = alien$data)
# To check summary results:
summary(influ)
# Most influential speciesL
influ$influential.species
# Visual diagnostics
sensi_plot(influ)
# You can specify which graph and parameter ("slope" or "intercept") to print: 
sensi_plot(influ, param = "slope", graphs = 2)
}
\author{
Gustavo Paterno & Gijsbert D.A. Werner
}
\references{
Ho, L. S. T. and Ane, C. 2014. "A linear-time algorithm for 
Gaussian and non-Gaussian trait evolution models". Systematic Biology 63(3):397-408.
}
\seealso{
\code{\link[phylolm]{phylolm}}, \code{\link{samp_phylm}},
\code{\link{influ_phylm}},\code{\link{sensi_plot}}
}

