% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_samp_phylm.R
\name{tree_samp_phylm}
\alias{tree_samp_phylm}
\title{Interaction between phylogenetic uncertainty and sensitivity to species sampling - Phylogenetic Linear Regression}
\usage{
tree_samp_phylm(formula, data, phy, n.sim = 30, n.tree = 2,
  breaks = seq(0.1, 0.5, 0.1), model = "lambda", track = TRUE, ...)
}
\arguments{
\item{formula}{The model formula}

\item{data}{Data frame containing species traits with row names matching tips
in \code{phy}.}

\item{phy}{A phylogeny (class 'phylo') matching \code{data}.}

\item{n.sim}{The number of times species are randomly deleted for each
\code{break}.}

\item{n.tree}{Number of times to repeat the analysis with n different trees picked 
randomly in the multiPhylo file.}

\item{breaks}{A vector containing the percentages of species to remove.}

\item{model}{The phylogenetic model to use (see Details). Default is \code{lambda}.}

\item{track}{Print a report tracking function progress (default = TRUE)}

\item{...}{Further arguments to be passed to \code{phylolm}}
}
\value{
The function \code{samp_phylm} returns a list with the following
components:

\code{formula}: The formula

\code{full.model.estimates}: Coefficients, aic and the optimised
value of the phylogenetic parameter (e.g. \code{lambda} or \code{kappa}) for
the full model without deleted species.

\code{sensi.estimates}: A data frame with all simulation
estimates. Each row represents a model rerun with a given number of species
\code{n.remov} removed, representing \code{n.percent} of the full dataset.
Columns report the calculated regression intercept (\code{intercept}),
difference between simulation intercept and full model intercept (\code{DIFintercept}),
the percentage of change in intercept compared to the full model (\code{intercept.perc})
and intercept p-value (\code{pval.intercept}). All these parameters are also reported
for the regression slope (\code{DIFestimate} etc.). Additionally, model aic value
(\code{AIC}) and the optimised value (\code{optpar}) of the phylogenetic
parameter (e.g. \code{kappa} or \code{lambda}, depending on the phylogenetic model
used) are reported. Lastly we reported the standardised difference in intercept 
(\code{sDIFintercept}) and slope (\code{sDIFestimate}).

\code{sign.analysis} For each break (i.e. each percentage of species
removed) this reports the percentage of statistically significant (at p<0.05)
intercepts (\code{perc.sign.intercept}) over all repititions as well as the
percentage of statisticaly significant (at p<0.05) slopes (\code{perc.sign.estimate}).

\code{data}: Original full dataset.
#' @note Please be aware that dropping species may reduce power to detect 
significant slopes/intercepts and may partially be responsible for a potential 
effect of species removal on p-values. Please also consult standardised differences
in the (summary) output.
}
\description{
Performs analyses of sensitivity to species sampling by randomly removing
species and detecting the effects on parameter estimates in a phylogenetic
linear regression, while evaluating uncertainty in trees topology.
}
\details{
This function randomly removes a given percentage of species (controlled by
\code{breaks}) from the full phylogenetic linear regression, fits a phylogenetic
linear regression model without these species using \code{\link[phylolm]{phylolm}},
repeats this many times (controlled by \code{n.sim}), stores the results and
calculates the effects on model parameters. It repeats this operation using n trees, 
randomly picked in a multiPhylo file.

All phylogenetic models from \code{phylolm} can be used, i.e. \code{BM},
\code{OUfixedRoot}, \code{OUrandomRoot}, \code{lambda}, \code{kappa},
\code{delta}, \code{EB} and \code{trend}. See ?\code{phylolm} for details.

Currently, this function can only implement simple linear models (i.e. \eqn{trait~
predictor}). In the future we will implement more complex models.

Output can be visualised using \code{sensi_plot}.
}
\examples{
\dontrun{
# Load data:
data(alien)
# Run analysis:
samp <- tree_samp_phylm(log(gestaLen) ~ log(adultMass), phy = alien$phy,
                                    data = alien$data, n.tree = 5, n.sim=10)
summary(samp)
head(samp$sensi.estimates)
# Visual diagnostics
sensi_plot(samp)
sensi_plot(samp, graphs = 1)
sensi_plot(samp, graphs = 2)
}
\dontshow{
# Load data:
data(alien)
# Run analysis:
samp <- tree_samp_phylm(log(gestaLen) ~ log(adultMass), phy = alien$phy,
                                    data = alien$data, n.tree = 2, n.sim=2)
summary(samp)
head(samp$sensi.estimates)
# Visual diagnostics
sensi_plot(samp)
sensi_plot(samp, graphs = 1)
sensi_plot(samp, graphs = 2)
}
}
\references{
Werner, G.D.A., Cornwell, W.K., Sprent, J.I., Kattge, J. & Kiers, E.T. (2014).
A single evolutionary innovation drives the deep evolution of symbiotic N2-fixation
in angiosperms. Nature Communications, 5, 4087.
  
Ho, L. S. T. and Ane, C. 2014. "A linear-time algorithm for 
Gaussian and non-Gaussian trait evolution models". Systematic Biology 63(3):397-408.
}
\seealso{
\code{\link[phylolm]{phylolm}}, \code{\link{samp_phylm}},
\code{\link{tree_phylm}},\code{\link{tree_samp_phyglm}},\code{\link{sensi_plot}}
}
\author{
Gustavo Paterno, Gijsbert D.A. Werner & Caterina Penone
}
