% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefs.sensmed.R
\name{LogL}
\alias{LogL}
\alias{LogL.bb}
\alias{LogL.bc}
\alias{LogL.cb}
\alias{LogL.cc}
\title{Implementation of loglikelihood functions for ML estimation of regression parameters}
\usage{
LogL.bb(par, Rho, X.expl = X.expl, X.resp = X.resp,
  outc.resp = outc.resp, outc.expl = outc.expl)

LogL.bc(par, Rho, X.expl = X.expl, X.resp = X.resp,
  outc.resp = outc.resp, outc.expl = outc.expl)

LogL.cb(par, Rho, X.expl = X.expl, X.resp = X.resp,
  outc.resp = outc.resp, outc.expl = outc.expl)

LogL.cc(par, Rho, X.expl = X.expl, X.resp = X.resp,
  outc.resp = outc.resp, outc.expl = outc.expl)
}
\arguments{
\item{par}{Vector of parameter values.}

\item{Rho}{The value of the sensitivity parameter.}

\item{X.expl}{The model matrix (see \code{\link{model.matrix}}) of \code{model.expl}}

\item{X.resp}{The model matrix (see \code{\link{model.matrix}}) of \code{model.resp}}

\item{outc.resp}{The outcome of \code{model.resp}, a vector.}

\item{outc.expl}{The outcome of \code{model.expl}, a column matrix.}
}
\description{
Implementation of loglikelihood functions for ML estimation of regression parameters for different combinations of
exposure, mediator and outcome models. The functions are named according to the convention \code{LogL."model.expl type""model.resp type"} where \code{b}
stands for binary probit regression and \code{c} stands for linear regression.
}
\seealso{
\code{\link{coefs.sensmed}}, \code{\link{maxLik}}
}
