% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight.R
\name{highlight}
\alias{highlight}
\title{Polarity Text Highlighting}
\usage{
highlight(x, original.text = NULL, file = "polarity.html", open = TRUE,
  digits = 3, ...)
}
\arguments{
\item{x}{A \code{sentiment_by} object.}

\item{original.text}{Optional original text (if the user wants to retain all
punctuation and capitalization).  Default uses the text stored in the
\code{sentiment_by} object that is striped of many punctuation marks and
capitalizations.}

\item{file}{A name of the html file output.}

\item{open}{logical.  If \code{TRUE} the text highlighting document will
attempt to be opened.}

\item{digits}{The number of digits to print for each row level average
sentiment score.}

\item{\ldots}{Ignored.}
}
\value{
Generates an html document with text highlighting.
}
\description{
Highlight sentences within elements (row IDs) by sentiment polarity
(positive = green; negative = pink) as an html file.
}
\examples{
library(data.table)
dat <- presidential_debates_2012
setDT(dat)

dat[, gr:={gr= paste(person, time); cumsum(c(TRUE, gr[-1]!= gr[-.N]))}]
dat <- dat[, list(person=person[1L], time=time[1L], dialogue=paste(dialogue,
    collapse = ' ')), by = gr][,gr:= NULL][]

(sent_dat <- with(dat, sentiment_by(dialogue, list(person, time))))

\dontrun{
highlight(sent_dat)
highlight(sent_dat, original.text = dat[["dialogue"]])

highlight(with(cannon_reviews, sentiment_by(review, number)))
}
}
