% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures.R
\name{to_global}
\alias{to_global}
\title{Merge sentiment measures into multiple weighted global sentiment indices}
\usage{
to_global(sentomeasures, lexicons = 1, features = 1, time = 1)
}
\arguments{
\item{sentomeasures}{a \code{sentomeasures} object created using \code{\link{sento_measures}}.}

\item{lexicons}{a \code{numeric} vector of weights, of size \code{length(sentomeasures$lexicons)}, in the same order.
By default set to 1, which means equally weighted.}

\item{features}{a \code{numeric} vector of weights, of size \code{length(sentomeasures$features)}, in the same order.
By default set to 1, which means equally weighted.}

\item{time}{a \code{numeric} vector of weights, of size \code{length(sentomeasures$time)}, in the same order. By default
set to 1, which means equally weighted.}
}
\value{
A \code{data.frame} with the different types of weighted global sentiment measures, named \code{"globLex"},
\code{"globFeat"}, \code{"globTime"} and \code{"global"}, with dates as row names. The last measure is an average
of the the three other measures.
}
\description{
Merges all sentiment measures into a weighted global textual sentiment measure for each of the
\code{lexicons}, \code{features}, and \code{time} dimensions.
}
\details{
This function returns no new \code{sentomeasures} object. The global sentiment measures as outputted can still
easily be added to regressions as an additional variable using the \code{x} argument in the \code{\link{sento_model}}
function. The measures are constructed from weights that indicate the importance (and sign) along each component from
the \code{lexicons}, \code{features}, and \code{time} dimensions. There is no condition in terms of allowed weights. For
example, the global index based on the supplied lexicon weights (\code{"globLex"}) is obtained first by multiplying
every sentiment measure with its corresponding weight (meaning, the weight given to the lexicon the sentiment is
computed with), then by taking the average per date.
}
\examples{
data("usnews")
data("lexicons")
data("valence")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- setup_lexicons(lexicons[c("LM_eng", "HENRY_eng")], valence[["valence_eng"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# merge into one global sentiment measure, with specified weighting for lexicons and features
global <- to_global(sentomeasures, lexicons = c(0.40, 0.60),
                                   features = c(0.10, -0.20, 0.30, -1),
                                   time = 1)

}
\seealso{
\code{\link{sento_model}}
}
\author{
Samuel Borms
}
