% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures_methods.R
\name{diff.sento_measures}
\alias{diff.sento_measures}
\title{Differencing of sentiment measures}
\usage{
\method{diff}{sento_measures}(x, lag = 1, differences = 1, ...)
}
\arguments{
\item{x}{a \code{sento_measures} object created using \code{\link{sento_measures}}.}

\item{lag}{a \code{numeric}, see documentation for the generic \code{\link{diff}}.}

\item{differences}{a \code{numeric}, see documentation for the generic \code{\link{diff}}.}

\item{...}{not used.}
}
\value{
A modified \code{sento_measures} object, with the measures replaced by the differenced measures as well as updated
statistics.
}
\description{
Differences the sentiment measures from a \code{sento_measures} object.
}
\examples{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

# construct a sento_measures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")], list_valence_shifters[["en"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sento_measures <- sento_measures(corpusSample, l, ctr)

# first-order difference sentiment measures with a lag of two
diffed <- diff(sento_measures, lag = 2, differences = 1)

}
\author{
Samuel Borms
}
