% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{LDA}
\alias{LDA}
\title{Create a Latent Dirichlet Allocation model}
\usage{
LDA(x, K = 5, alpha = 1, beta = 0.01)
}
\arguments{
\item{x}{tokens object containing the texts. A coercion will be attempted if \code{x} is not a tokens.}

\item{K}{the number of topics}

\item{alpha}{the hyperparameter of topic-document distribution}

\item{beta}{the hyperparameter of vocabulary distribution}
}
\value{
An S3 list containing the model parameter and the estimated mixture.
This object corresponds to a Gibbs sampler estimator with zero iterations.
The MCMC can be iterated using the \code{\link[=grow]{grow()}} function.
\itemize{
\item \code{tokens} is the tokens object used to create the model
\item \code{vocabulary} contains the set of words of the corpus
\item \code{it} tracks the number of Gibbs sampling iterations
\item \code{za} is the list of topic assignment, aligned to the \code{tokens} object with
padding removed
\item \code{logLikelihood} returns the measured log-likelihood at each iteration,
with a breakdown of the likelihood into hierarchical components as
attribute
}

The \code{\link[=topWords]{topWords()}} function easily extract the most probables words of each
topic/sentiment.
}
\description{
This function initialize a Latent Dirichlet Allocation model.
}
\details{
The \code{rJST.LDA} methods enable the transition from a previously
estimated \link{LDA} model to a sentiment-aware \code{rJST} model. The function
retains the previously estimated topics and randomly assigns sentiment to
every word of the corpus. The new model will retain the iteration count of
the initial \link{LDA} model.
}
\examples{
\donttest{# creating a model
LDA(ECB_press_conferences_tokens, K = 5, alpha = 0.1, beta = 0.01)

# estimating an LDA model
lda <- LDA(ECB_press_conferences_tokens)
lda <- grow(lda, 100)}
}
\references{
Blei, D.M., Ng, A.Y. and Jordan, M.I. (2003). \href{https://www.jmlr.org/papers/volume3/blei03a/blei03a.pdf}{Latent Dirichlet Allocation}.
\emph{Journal of Machine Learning Research}, 3, 993--1022.
}
\seealso{
Growing a model: \code{\link[=grow]{grow()}}, extracting top words: \code{\link[=topWords]{topWords()}}

Other topic models: 
\code{\link{JST}()},
\code{\link{rJST}()},
\code{\link{sentopicmodel}()}
}
\author{
Olivier Delmarcelle
}
\concept{topic models}
