% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqminer.R
\name{annotateGene}
\alias{annotateGene}
\title{Annotate a test variant}
\usage{
annotateGene(param, chrom, position, ref, alt)
}
\arguments{
\item{param}{a list of annotation configuaration (e.g. reference file, gene definition)}

\item{chrom}{a vector of chromosome names}

\item{position}{a vector of chromosome positions}

\item{ref}{a vector of reference alleles}

\item{alt}{a vector of alternative alleles}
}
\value{
annotated results in a data frame structure
}
\description{
Annotate a test variant
}
\examples{
if (.Platform$endian == "little") {
  param <- list(reference = system.file("tabanno/test.fa", package = "seqminer"),
                geneFile = system.file("tabanno/test.gene.txt", package = "seqminer"))
  param <- makeAnnotationParameter(param)
  print(param)
  annotateGene(param, c("1", "1"), c(3, 5) , c("A", "C"), c("G", "C"))
} else {
  message("Tabix does not work well for big endian for now")
}
}
\seealso{
makeAnnotationParameter
}
