% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPedComp.R
\name{PlotPedComp}
\alias{PlotPedComp}
\title{Visualise PedCompare Output}
\usage{
PlotPedComp(Counts, sameSize = FALSE)
}
\arguments{
\item{Counts}{a 7x5x2 array with counts of matches and mismatches per
category (genotyped vs dummy), as returned by \code{\link{PedCompare}}.}

\item{sameSize}{logical, make all per-category Venn diagrams the same size
\code{TRUE}, or make their size proportional to the counts (\code{FALSE},
the default). If \code{TRUE}, a warning is printed at the bottom.}
}
\description{
square Venn diagrams with \code{\link{PedCompare}}
  \code{Counts}.
}
\examples{
data(SeqOUT_griffin, FieldMums_griffin, package="sequoia")
PC.g <- PedCompare(Ped1 = cbind(FieldMums_griffin, sire=NA),
                   Ped2 = SeqOUT_griffin$Pedigree)
PlotPedComp(PC.g$Counts)

}
\seealso{
\code{\link{PedCompare}}
}
