% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcPairLL.R
\name{FortifyPairs}
\alias{FortifyPairs}
\title{Make Pairs Fortran Compatible}
\usage{
FortifyPairs(Pairs, gID, Renamed, LH, Ped)
}
\arguments{
\item{Pairs}{dataframe with columns ID1 - ID2 - Sex1 - Sex2 - AgeDif - focal
- k.}

\item{gID}{character vector with IDs of genotyped individuals.}

\item{Renamed}{length-2 list (dams, sires) each with a 2-column dataframe.
matching character IDs to negative numbers, for dummified individuals.
Element of the list returned by \code{\link{PedToNum}}.}

\item{LH}{lifehistory dataframe, ID - Sex - BirthYear.}

\item{Ped}{pedigree, to ensure dams have sex=1 & sires sex=2}
}
\value{
A named list, with elements ID - Sex - AgeDif - focal. The first two
  are per individual and thus each have length 2*nrow(Pairs), while the last
  two have length 1*nrow(Pairs).
}
\description{
Convert dataframe \code{Pairs} into a list of integer vectors.
  Called only by \code{\link{CalcPairLL}}.
}
\keyword{internal}
