% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractional_polynomial_models.R
\name{fp_model}
\alias{fp_model}
\title{A fractional polynomial model.}
\usage{
fp_model(age, p, pos = NULL, tot = NULL, status = NULL, link = "logit")
}
\arguments{
\item{age}{the age vector.}

\item{p}{the powers of the predictor.}

\item{pos}{the positive count vector (optional if status is provided).}

\item{tot}{the total count vector (optional if status is provided).}

\item{status}{the serostatus vector (optional if pos & tot are provided).}

\item{link}{the link function for model. Defaulted to "logit".}
}
\value{
a list of class fp_model with 5 items
  \item{datatype}{type of data used for fitting model (aggregated or linelisting)}
  \item{df}{the dataframe used for fitting the model}
  \item{info}{a fitted glm model}
  \item{sp}{seroprevalence}
  \item{foi}{force of infection}
}
\description{
Refers to section 6.2.
}
\examples{
df <- hav_be_1993_1994
model <- fp_model(
  df$age, pos = df$pos, tot = df$tot,
  p=c(1.5, 1.6), link="cloglog")
plot(model)

}
\seealso{
[stats::glm()] for more information on glm object
}
