% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitVoigtPeaksSMC.R
\name{fitVoigtPeaksSMC}
\alias{fitVoigtPeaksSMC}
\title{Fit the model with Voigt peaks using Sequential Monte Carlo (SMC).}
\usage{
fitVoigtPeaksSMC(wl, spc, lPriors, conc = rep(1, nrow(spc)), npart = 10000,
  rate = 0.9, mcAR = 0.23, mcSteps = 10, minESS = npart/2,
  destDir = NA)
}
\arguments{
\item{wl}{Vector of \code{nwl} wavenumbers at which the spetra are observed.}

\item{spc}{\code{n_y * nwl} Matrix of observed Raman spectra.}

\item{lPriors}{List of hyperparameters for the prior distributions.}

\item{conc}{Vector of \code{n_y} nanomolar (nM) dye concentrations for each observation.}

\item{npart}{number of SMC particles to use for the importance sampling distribution.}

\item{rate}{the target rate of reduction in the effective sample size (ESS).}

\item{mcAR}{target acceptance rate for the MCMC kernel}

\item{mcSteps}{number of iterations of the MCMC kernel}

\item{minESS}{minimum effective sample size, below which the particles are resampled.}

\item{destDir}{destination directory to save intermediate results (for long-running computations)}
}
\description{
Fit the model with Voigt peaks using Sequential Monte Carlo (SMC).
}
\examples{
wavenumbers <- seq(200,600,by=10)
spectra <- matrix(nrow=1, ncol=length(wavenumbers))
peakLocations <- c(300,500)
peakAmplitude <- c(10000,4000)
peakScale <- c(10, 15)
signature <- weightedLorentzian(peakLocations, peakScale, peakAmplitude, wavenumbers)
baseline <- 1000*cos(wavenumbers/200) + 2*wavenumbers
spectra[1,] <- signature + baseline + rnorm(length(wavenumbers),0,200)
lPriors <- list(scaG.mu=log(11.6) - (0.4^2)/2, scaG.sd=0.4, scaL.mu=log(11.6) - (0.4^2)/2,
   scaL.sd=0.4, bl.smooth=5, bl.knots=20, loc.mu=peakLocations, loc.sd=c(5,5),
   beta.mu=c(5000,5000), beta.sd=c(5000,5000), noise.sd=200, noise.nu=4)
result <- fitVoigtPeaksSMC(wavenumbers, spectra, lPriors, npart=100, mcSteps=1)
}
