% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-exports.R
\name{Exports}
\alias{Exports}
\title{R6 Class representing storage exports endpoints}
\description{
R6 Class representing storage exports resource endpoints.
}
\examples{

## ------------------------------------------------
## Method `Exports$query`
## ------------------------------------------------

\dontrun{
 exports_object <- Exports$new(
   auth = auth
 )

 # List all your running or failed export jobs on the volume
 exports_object$query(volume = volume, state = c("RUNNING", "FAILED"))
}


## ------------------------------------------------
## Method `Exports$get`
## ------------------------------------------------

\dontrun{
 exports_object <- Exports$new(
   auth = auth
 )

 # Get export job by ID
 exports_object$get(id = id)
}


## ------------------------------------------------
## Method `Exports$submit_export`
## ------------------------------------------------

\dontrun{
 exports_object <- Exports$new(
   auth = auth
 )

 # Submit export job
 exp_job1 <- exports_object$submit_export(
                          source_file = test_file,
                          destination_volume = vol1,
                          destination_location = "new_volume_file.txt"
                )
}

}
\section{Super class}{
\code{\link[sevenbridges2:Resource]{sevenbridges2::Resource}} -> \code{Exports}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Exports-new}{\code{Exports$new()}}
\item \href{#method-Exports-query}{\code{Exports$query()}}
\item \href{#method-Exports-get}{\code{Exports$get()}}
\item \href{#method-Exports-submit_export}{\code{Exports$submit_export()}}
\item \href{#method-Exports-delete}{\code{Exports$delete()}}
\item \href{#method-Exports-clone}{\code{Exports$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Exports-new"></a>}}
\if{latex}{\out{\hypertarget{method-Exports-new}{}}}
\subsection{Method \code{new()}}{
Create a new Exports object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Exports$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Exports-query"></a>}}
\if{latex}{\out{\hypertarget{method-Exports-query}{}}}
\subsection{Method \code{query()}}{
This call lists export jobs initiated by particular user.
Note that when you export a file from a project on the Platform into a
volume, you write to your cloud storage bucket.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Exports$query(
  volume = NULL,
  state = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{volume}}{Volume id or Volume object. List all exports
into this particular volume. Optional.}

\item{\code{state}}{The state of the export job. Possible values are:
\itemize{
\item \code{PENDING}: the export is queued;
\item \code{RUNNING}: the export is running;
\item \code{COMPLETED}: the export has completed successfully;
\item \code{FAILED}: the export has failed.
}
Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{state = c("RUNNING", "FAILED")
}\if{html}{\out{</div>}}}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{Export}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 exports_object <- Exports$new(
   auth = auth
 )

 # List all your running or failed export jobs on the volume
 exports_object$query(volume = volume, state = c("RUNNING", "FAILED"))
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Exports-get"></a>}}
\if{latex}{\out{\hypertarget{method-Exports-get}{}}}
\subsection{Method \code{get()}}{
This call will return the details of an export job.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Exports$get(id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The export job identifier (id).}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Export}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 exports_object <- Exports$new(
   auth = auth
 )

 # Get export job by ID
 exports_object$get(id = id)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Exports-submit_export"></a>}}
\if{latex}{\out{\hypertarget{method-Exports-submit_export}{}}}
\subsection{Method \code{submit_export()}}{
This call lets you queue a job to export a file from a
project on the Platform into a volume. The file selected for export must
not be a public file or an alias. Aliases are objects stored in your
cloud storage bucket which have been made available on the Platform.
The volume you are exporting to must be configured for
read-write access. To do this, set the \code{access_mode} parameter to
\code{RW} when creating or modifying a volume. \cr

Essentially, the call writes to your cloud storage bucket via the
volume. If this call is successful, the original project file will
become an alias to the newly exported object on the volume.
The source file will be deleted from the Platform and, if no more
copies of this file exist, it will no longer count towards your total
storage price on the Platform. \cr
In summary, once you export a file from the Platform to a volume, it is
no longer part of the storage on the Platform and cannot be exported
again. \cr

Read more about this operation in our documentation
\href{https://docs.sevenbridges.com/reference/start-an-export-job-v2}{here}.
\cr

If you want to export multiple files, the recommended way is to do it
in bulk considering the API rate limit (\href{https://docs.sevenbridges.com/docs/api-rate-limit}{learn more}).
Bulk operations will be implemented in next releases.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Exports$submit_export(
  source_file,
  destination_volume,
  destination_location,
  overwrite = FALSE,
  copy_only = FALSE,
  properties = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source_file}}{File id or File object you want to export to
the volume.}

\item{\code{destination_volume}}{Volume id or Volume object you want to
export files into.}

\item{\code{destination_location}}{Volume-specific location to which the
file will be exported.
This location should be recognizable to the underlying cloud service as
a valid key or path to a new file. Please note that if this volume has
been configured with a prefix parameter, the value of prefix will be
prepended to location before attempting to create the file on the
volume.

If you would like to export the file into some folder on the volume,
please add folder name as prefix before file name in form
\verb{<folder-name>/<file-name>}.}

\item{\code{overwrite}}{Set to \code{TRUE} if you want to overwrite the item
if another one with the same name already exists at the destination.}

\item{\code{copy_only}}{If \code{TRUE}, file will be copied to a volume but
source file will remain on the Platform.}

\item{\code{properties}}{Named list of additional volume properties, like:
\itemize{
\item \code{sse_algorithm} - S3 server-side encryption to use when
exporting to this bucket. Supported values:
\code{AES256} (SSE-S3 encryption), \code{aws:kms}, \code{null}
(no server-side encryption). Default: \code{AES256}.
\item \code{sse_aws_kms_key_id}: Applies to type: \code{s3}.
If AWS KMS encryption is used, this should be set to the required
KMS key. If not set and \code{aws:kms} is set as \code{sse_algorithm},
default KMS key is used.
\item \code{aws_canned_acl}: S3 canned ACL to apply on the object
on during export. Supported values: any one of
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl}{S3 canned ACLs};
\code{null} (do not apply canned ACLs). Default: \code{null}.
}}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Export}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 exports_object <- Exports$new(
   auth = auth
 )

 # Submit export job
 exp_job1 <- exports_object$submit_export(
                          source_file = test_file,
                          destination_volume = vol1,
                          destination_location = "new_volume_file.txt"
                )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Exports-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Exports-delete}{}}}
\subsection{Method \code{delete()}}{
Deleting export jobs is not possible.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Exports$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Exports-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Exports-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Exports$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
