% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-invoices.R
\name{Invoices}
\alias{Invoices}
\title{R6 Class representing invoices endpoints}
\description{
R6 Class representing invoice resource endpoints
}
\examples{

## ------------------------------------------------
## Method `Invoices$query`
## ------------------------------------------------

\dontrun{
 invoices_object <- Invoices$new(
   auth = auth
 )

 # List all your invoices
 invoices_object$query(billing_group = billing_group)
}


## ------------------------------------------------
## Method `Invoices$get`
## ------------------------------------------------

\dontrun{
 invoices_object <- Invoices$new(
   auth = auth
 )

 # Get single invoice by id
 invoices_object$get(id = id)
}

}
\section{Super class}{
\code{\link[sevenbridges2:Resource]{sevenbridges2::Resource}} -> \code{Invoices}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Invoices-new}{\code{Invoices$new()}}
\item \href{#method-Invoices-query}{\code{Invoices$query()}}
\item \href{#method-Invoices-get}{\code{Invoices$get()}}
\item \href{#method-Invoices-clone}{\code{Invoices$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sevenbridges2" data-topic="Resource" data-id="delete"><a href='../../sevenbridges2/html/Resource.html#method-Resource-delete'><code>sevenbridges2::Resource$delete()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Invoices-new"></a>}}
\if{latex}{\out{\hypertarget{method-Invoices-new}{}}}
\subsection{Method \code{new()}}{
Create a new Invoices object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Invoices$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Invoices-query"></a>}}
\if{latex}{\out{\hypertarget{method-Invoices-query}{}}}
\subsection{Method \code{query()}}{
The call returns information about all your available
invoices, unless you use the \code{billing_group} query parameter to specify
the ID of a particular billing group, in which case it will return the
invoice incurred by that billing group only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Invoices$query(
  billing_group = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{billing_group}}{ID of a billing group or billing group object
you want to list invoices for. Optional.}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like query parameters or 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{Invoice}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 invoices_object <- Invoices$new(
   auth = auth
 )

 # List all your invoices
 invoices_object$query(billing_group = billing_group)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Invoices-get"></a>}}
\if{latex}{\out{\hypertarget{method-Invoices-get}{}}}
\subsection{Method \code{get()}}{
This call retrieves information about a selected invoice,
including the costs for analysis and storage, and the invoice period.
Use the call to list invoices to retrieve the \code{invoice_id}s for a
specified billing group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Invoices$get(id, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The ID of the invoice you are querying.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Invoice}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 invoices_object <- Invoices$new(
   auth = auth
 )

 # Get single invoice by id
 invoices_object$get(id = id)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Invoices-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Invoices-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Invoices$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
