% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{geos_unary}
\alias{geos_unary}
\alias{st_buffer}
\alias{geos_unary}
\alias{st_boundary}
\alias{geos_unary}
\alias{st_convex_hull}
\alias{geos_unary}
\alias{st_simplify}
\alias{geos_unary}
\alias{st_triangulate}
\alias{geos_unary}
\alias{st_voronoi}
\alias{geos_unary}
\alias{st_polygonize}
\alias{geos_unary}
\alias{st_line_merge}
\alias{geos_unary}
\alias{st_centroid}
\alias{geos_unary}
\alias{st_point_on_surface}
\alias{geos_unary}
\alias{st_node}
\alias{geos_unary}
\alias{st_segmentize}
\title{Geometric unary operations on simple feature geometry sets}
\usage{
st_buffer(x, dist, nQuadSegs = 30)

st_boundary(x)

st_convex_hull(x)

st_simplify(x, preserveTopology = FALSE, dTolerance = 0)

st_triangulate(x, dTolerance = 0, bOnlyEdges = FALSE)

st_voronoi(x, envelope, dTolerance = 0, bOnlyEdges = FALSE)

st_polygonize(x)

st_line_merge(x)

st_centroid(x, ..., of_largest_polygon = FALSE)

st_point_on_surface(x)

st_node(x)

st_segmentize(x, dfMaxLength, ...)
}
\arguments{
\item{x}{object of class \code{sfg}, \code{sfg} or \code{sf}}

\item{dist}{numeric; buffer distance for all, or for each of the elements in \code{x}; in case
\code{dist} is a \code{units} object, it should be convertible to \code{arc_degree} if
\code{x} has geographic coordinates, and to \code{st_crs(x)$units} otherwise}

\item{nQuadSegs}{integer; number of segments per quadrant (fourth of a circle)}

\item{preserveTopology}{logical; carry out topology preserving simplification?}

\item{dTolerance}{numeric; tolerance parameter}

\item{bOnlyEdges}{logical; if TRUE, return lines, else return polygons}

\item{envelope}{object of class \code{sfc} or \code{sfg} containing a \code{POLYGON} with the envelope for a voronoi diagram; this only takes effect when it is larger than the default envelope, chosen when \code{envelope} is an empty polygon}

\item{...}{ignored}

\item{of_largest_polygon}{logical; for \code{st_centroid}: if \code{TRUE}, return centroid of the largest (sub)polygon of a \code{MULTIPOLYGON} rather than of the whole \code{MULTIPOLYGON}}

\item{dfMaxLength}{maximum length of a line segment. If \code{x} has geographical coordinates (long/lat), \code{dfMaxLength} is either a numeric expressed in meter, or an object of class \code{units} with length units or unit \code{rad}, and segmentation takes place along the great circle, using \link[geosphere]{gcIntermediate}.}
}
\value{
an object of the same class of \code{x}, with manipulated geometry.
}
\description{
Geometric unary operations on simple feature geometry sets. These are all generics, with methods for \code{sfg}, \code{sfc} and \code{sf} objects, returning an object of the same class.
}
\details{
\code{st_triangulate} requires GEOS version 3.4 or above

\code{st_voronoi} requires GEOS version 3.5 or above

in case of \code{st_polygonize}, \code{x} must be an object of class \code{LINESTRING} or \code{MULTILINESTRING}, or an \code{sfc} geometry list-column object containing these

in case of \code{st_line_merge}, \code{x} must be an object of class \code{MULTILINESTRING}, or an \code{sfc} geometry list-column object containing these

\code{st_point_on_surface} returns a point guaranteed to be on the (multi)surface.

\code{st_node} add nodes to linear geometries at intersections without node
}
\examples{
nc = st_read(system.file("shape/nc.shp", package="sf"))
plot(st_convex_hull(nc))
plot(nc, border = grey(.5))
set.seed(1)
x = st_multipoint(matrix(runif(10),,2))
box = st_polygon(list(rbind(c(0,0),c(1,0),c(1,1),c(0,1),c(0,0))))
if (sf_extSoftVersion()["GEOS"] >= "3.5.0") {
 v = st_sfc(st_voronoi(x, st_sfc(box)))
 plot(v, col = 0, border = 1, axes = TRUE)
 plot(box, add = TRUE, col = 0, border = 1) # a larger box is returned, as documented
 plot(x, add = TRUE, col = 'red', cex=2, pch=16)
 plot(st_intersection(st_cast(v), box)) # clip to smaller box
 plot(x, add = TRUE, col = 'red', cex=2, pch=16)
}
mls = st_multilinestring(list(matrix(c(0,0,0,1,1,1,0,0),,2,byrow=TRUE)))
st_polygonize(st_sfc(mls))
mls = st_multilinestring(list(rbind(c(0,0), c(1,1)), rbind(c(2,0), c(1,1))))
st_line_merge(st_sfc(mls))
plot(nc, axes = TRUE)
plot(st_centroid(nc), add = TRUE, pch = 3)
mp = st_combine(st_buffer(st_sfc(lapply(1:3, function(x) st_point(c(x,x)))), 0.2 * 1:3))
plot(mp)
plot(st_centroid(mp), add = TRUE, col = 'red') # centroid of combined geometry
plot(st_centroid(mp, of_largest_polygon = TRUE), add = TRUE, col = 'blue', pch = 3)
plot(nc, axes = TRUE)
plot(st_point_on_surface(nc), add = TRUE, pch = 3)
l = st_linestring(rbind(c(0,0), c(1,1), c(0,1), c(1,0), c(0,0)))
st_polygonize(st_node(l))
sf = st_sf(a=1, geom=st_sfc(st_linestring(rbind(c(0,0),c(1,1)))), crs = 4326)
seg = st_segmentize(sf, units::set_units(100, km))
seg = st_segmentize(sf, units::set_units(0.01, rad))
nrow(seg$geom[[1]])
}
