% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc.R
\name{st_zm}
\alias{st_zm}
\title{Drop or add Z and/or M dimensions from feature geometries}
\usage{
st_zm(x, ..., drop = TRUE, what = "ZM")
}
\arguments{
\item{x}{object of class \code{sfg}, \code{sfc} or \code{sf}}

\item{...}{ignored}

\item{drop}{logical; drop, or (\code{FALSE}) add?}

\item{what}{character which dimensions to drop or add}
}
\description{
Drop Z and/or M dimensions from feature geometries, resetting classes appropriately
}
\details{
Only combinations \code{drop=TRUE}, \code{what = "ZM"}, and \code{drop=FALSE}, \code{what="Z"} are supported so far.
In case \code{add=TRUE}, \code{x} should have \code{XY} geometry, and zero values are added for \code{Z}.
}
\examples{
st_zm(st_linestring(matrix(1:32,8)))
x = st_sfc(st_linestring(matrix(1:32,8)), st_linestring(matrix(1:8,2)))
st_zm(x)
a = st_sf(a = 1:2, geom=x)
st_zm(a)
}
