% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfcr_matrix.R
\name{sfcr_matrix}
\alias{sfcr_matrix}
\title{Create balance-sheet or transactions-flow matrices}
\usage{
sfcr_matrix(columns, codes, ...)
}
\arguments{
\item{columns}{Vector containing the name of the columns in the matrix.}

\item{codes}{A vector containing the abbreviation of the
column names that is going to be used as a reference to
build the rows. They must be provided in the same order
as the \code{columns}.}

\item{...}{Vectors that fill the rows of the matrix.
The first element of each vector \strong{must} be the name of the
row in the respective matrix. The remaining elements of the vector
must be name-value pairs that exactly matches the \code{codes} argument.
See the examples for further details.}
}
\description{
Create balance-sheet or transactions-flow matrices
}
\note{
This function can be used to generate a transactions-
flow matrix as well as a balance-sheet matrix. If the user
wishes to validate these matrices with the simulated data,
please pay attention to the following details:
\itemize{
\item Transactions-flow Matrix:
In the transactions-flow matrix, the \code{sum} column is
going to be generated automatically by the validation
function. Please do not add it by hand.
\item Balance-sheet Matrix:
In the balance-sheet matrix, it might be the case that some
rows do not sum to zero. Therefore, the user must supply
by hand the non-zero values of the \code{sum} column.
This column should always be the last column of the matrix
and should always be named as "Sum". If there's no column
named as "Sum", it will be generated automatically by the
validation function with all entries equal to zero.
}
}
\examples{
# Balance-sheet matrix

bs_pc <- sfcr_matrix(
  columns = c("Households", "Firms", "Government", "Central bank", "sum"),
  codes = c("h", "f", "g", "cb", "s"),
  r1 = c("Money", h = "+Hh", cb = "-Hs"),
  r2 = c("Bills", h = "+Bh", g = "-Bs", cb = "+Bcb"),
  r3 = c("Balance", h = "-V", g = "+V")
)


# Transactions-flow matrix
tfm_pc <- sfcr_matrix(
  columns = c("Households", "Firms", "Government", "CB current", "CB capital"),
  codes = c("h", "f", "g", "cbc", "cbk"),
  c("Consumption", h = "-C", f = "+C"),
  c("Govt. Expenditures", f = "+G", g = "-G"),
  c("Income", h = "+Y", f = "-Y"),
  c("Int. payments", h = "+r[-1] * Bh[-1]", g = "-r[-1] * Bs[-1]", cbc = "+r[-1] * Bcb[-1]"),
  c("CB profits", g = "+r[-1] * Bcb[-1]", cbc = "-r[-1] * Bcb[-1]"),
  c("Taxes", h = "-TX", g = "+TX"),
  c("Ch. Money", h = "-(Hh - Hh[-1])", cbk = "+(Hs - Hs[-1])"),
  c("Ch. Bills", h = "-(Bh - Bh[-1])", g = "+(Bs - Bs[-1])", cbk = "-(Bcb - Bcb[-1])")
)
}
\author{
João Macalós, \email{joaomacalos@gmail.com}
}
