% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localG.R
\name{local_g}
\alias{local_g}
\alias{local_g_perm}
\title{Local G}
\usage{
local_g(x, nb, wt, alternative = "two.sided", ...)

local_g_perm(x, nb, wt, nsim = 499, alternative = "two.sided", ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{nb}{a neighbor list object for example as created by \code{st_contiguity()}.}

\item{wt}{a weights list as created by \code{st_weights()}.}

\item{alternative}{default \code{"two.sided"}. Should be one of \code{"greater"}, \code{"less"}, or \code{"two.sided"} to specify the alternative hypothesis.}

\item{...}{methods passed to \code{\link[spdep:localG]{spdep::localG()}} or \code{\link[spdep:localG]{spdep::localG_perm()}}}

\item{nsim}{The number of simulations to run.}
}
\value{
a \code{data.frame} with columns:
\itemize{
\item \code{gi}: the observed statistic
\item \code{e_gi}: the permutation sample mean
\item \code{var_gi}: the permutation sample variance
\item \code{p_value}: the p-value using sample mean and standard deviation
\item \code{p_folded_sim}: p-value based on the implementation of Pysal which always assumes a two-sided test taking the minimum possible p-value
\item \code{skewness}: sample skewness
\item \code{kurtosis}: sample kurtosis
}
}
\description{
Local G
}
\examples{
x <- guerry$crime_pers
nb <- st_contiguity(guerry)
wt <- st_weights(nb)

res <- local_g_perm(x, nb, wt)

head(res)
}
