% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfnetworks.R
\name{st_as_graph}
\alias{st_as_graph}
\alias{st_as_graph.sf}
\alias{st_as_graph.sfc}
\title{Create an sfnetwork}
\usage{
st_as_graph(x, nb, wt)

\method{st_as_graph}{sf}(x, nb, wt)

\method{st_as_graph}{sfc}(x, nb, wt)
}
\arguments{
\item{x}{object of class \code{sf} or \code{sfc}.}

\item{nb}{a neighbor list. If \code{x} is class \code{sf}, the unquote named of the column. If \code{x} is class \code{sfc}, an object of class \code{nb} as created from \code{st_contiguity()}.}

\item{wt}{optional. A weights list as generated by \code{st_weights()}.  . If \code{x} is class \code{sf}, the unquote named of the column. If \code{x} is class \code{sfc}, the weights list itself.}
}
\description{
Given an \code{sf} or \code{sfc} object and neighbor and weights lists, create an \code{sfnetwork} object.
}
\examples{
library(magrittr)

guerry_nb \%>\%
  st_as_graph(nb, wt)

}
\seealso{
\code{\link[=st_as_nodes]{st_as_nodes()}} and \code{\link[=st_as_edges]{st_as_edges()}}
}
