% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pariwise-colocation-impl.R
\name{pairwise_colocation}
\alias{pairwise_colocation}
\title{Pairwise Colocation Quotient}
\usage{
pairwise_colocation(A, B, nb, nsim = 99)
}
\arguments{
\item{A}{a character or factor vector.}

\item{B}{a character or factor vector.}

\item{nb}{a neighbors list e.g. created by \code{\link[=st_knn]{st_knn()}} or \code{\link[=st_contiguity]{st_contiguity()}}}

\item{nsim}{default \code{99}. An integer representing how many simulations to run for calculating the simulated p-values.}
}
\value{
A matrix where the rownames are the unique values of A and the column names are the unique values of B and their simulated p-values in the form of \verb{p_sim_\{B\}}.
}
\description{
Calculate the pairwise colocation quotient (CLQ) for two categorical variables using conditional permutation.
}
\details{
\subsection{Intuition}{

The pairwise CLQ is used to test if there is a spatial directional association between subcategories of two vectors \code{A} and \code{B}. Compared to the cross-K metric and the join count statistic, the pairwise CLQ can elucidate the presence of an asymmetric relationship between subcategories of A and B. A and B can either be separate categorical vectors or the same categorical vector.

"The null hypothesis for a CLQ-based analysis is 'given the clustering of the joint population, there is no spatial association between pairs of categorical subsets.'"
}

\subsection{Definition}{

The pairwise colocation quotient is defined as "the ratio of observed to expected proportions of B among A's nearest neighbors. Formally this is given by
\eqn{CLQ_{A \to B} = \frac{{C_{A \to B} / N_A}}{N^{'}_{B} / (N - 1)}}" where \eqn{C_{A \to B} = \sum_{i = 1}^{N_A}\sum_{j = 1}^{v}\frac{B_{ij}(1,0)}{v}}.
}

\subsection{Inference}{

Inference is done using conditional permutation as suggested by Anselin 1995 where a number of replicates are created. The observed values are compared to the replicates and a the simulated p-value is the proportion of cases where the observed is more extreme as compared to replicate. The simulated p-value returns the lower p-value of either tail.
}

\subsection{Interpretation}{

Given that the CLQ is a ratio of the observed to expected, we interpret values larger than one to mean that there is more colocation than to be expected under the null hypothesis of no spatial association. When the value is smaller than 0, we interpret it to mean that there is less colocation than expected under the null.
}
}
\examples{
A <- guerry$main_city
B <- guerry$region
nb <- st_knn(sf::st_geometry(guerry), 5)
pairwise_colocation(B, A, nb)
pairwise_colocation(B, B, nb, 199)
}
