% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cardinality.R
\name{st_cardinalties}
\alias{st_cardinalties}
\title{Calculate neighbor cardinalities}
\usage{
st_cardinalties(nb)
}
\arguments{
\item{nb}{A neighbor list object as created by \code{st_neighbors()}.}
}
\value{
an integer vector with the same length as \code{nb}.
}
\description{
Identify the cardinality of a neighbor object. Utilizes \code{spdep::card()} for objects with class \code{nb}, otherwise returns \code{lengths(nb)}.
}
\examples{
nb <- st_contiguity(sf::st_geometry(guerry))
st_cardinalties(nb)
}
\seealso{
Other other: 
\code{\link{st_nb_lag}()},
\code{\link{st_nb_lag_cumul}()}
}
\concept{other}
