% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_url_query_string.R
\name{build_constituency_query_string}
\alias{build_constituency_query_string}
\title{Build constituency section of get_boundary_areaname query string}
\usage{
build_constituency_query_string(constituency_list, ...)
}
\arguments{
\item{constituency_list}{Vector of constituency names}

\item{...}{Additional strings to be added to the query string}
}
\value{
A string formatted for 'where' portion of url for querying Open Geography portal
}
\description{
Create correctly formatted 'where' part of url query string used by
get_boundary_areaname to fetch contituency boundaries
}
\examples{
build_constituency_query_string("Westminster", "LAD22NM", "3D")
"\%20(\%20'LAD22NM\%20\%3D\%20'Westminster')\%20"

build_constituency_query_string(c("Westminster", "Tower Hamlets"), "LAD22NM", "3D")
"\%20(\%20'LAD22NM\%20\%3D\%20'Westminster'\%20OR\%20LAD22NM\%20\%3D\%20'Tower\%20Hamlets')\%20"

}
