% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgdGMF-class.R
\name{predict.sgdgmf}
\alias{predict.sgdgmf}
\title{Predict method for GMF models}
\usage{
\method{predict}{sgdgmf}(
  object,
  ...,
  newY = NULL,
  newX = NULL,
  type = c("link", "response", "terms", "coef"),
  parallel = FALSE,
  nthreads = 1
)
}
\arguments{
\item{object}{an object of class \code{sgdgmf}}

\item{...}{further arguments passed to or from other methods}

\item{newY}{optionally, a matrix of new response variable}

\item{newX}{optionally, a matrix of new covariate values}

\item{type}{the type of prediction which should be returned}

\item{parallel}{if \code{TRUE}, allows for parallel computing using the package \code{foreach}}

\item{nthreads}{number of cores to be used in parallel (only if \code{parallel=TRUE})}
}
\value{
If \code{type="link"} or \code{typr="response"}, a matrix of predictions.
If \code{type="terms"}, a list of matrices containing the fields \code{XB}, \code{AZ} and \code{UV}.
If \code{type="coef"}, a list of matrices containing the field \code{B}, \code{A}, \code{U} and \code{V}.
}
\description{
Computes the predictions of a GMF model. Out-of-sample predictions for a new
set of responses and covariates are computed via MLE, by keeping fixed the values
of the estimated \code{B} and \code{V} and maximizing the likelihood with respect
to \code{A} and \code{U}.
}
\details{
If \code{newY} and \code{newX} are omitted, the predictions are based on the data
used for the fit. In that case, the predictions corresponds to the fitted values.
If \code{newY} and \code{newX} are provided, a corresponding set of \code{A} and
\code{U} are estimated via maximum likelihood using the \code{glm.fit} function.
By doing so, \code{B} and \code{V} are kept fixed.
}
\examples{
# Load the sgdGMF package
library(sgdGMF)

# Generate data from a Poisson model
data = sim.gmf.data(n = 120, m = 20, ncomp = 5, family = poisson())
train = sample(1:120, size = 100)
test = setdiff(1:120, train)

Y = data$Y[train, ]
newY = data$Y[test, ]

# Fit a GMF model with 3 latent factors
gmf = sgdgmf.fit(Y, ncomp = 3, family = poisson())

# Get the fitted values of a GMF model
str(predict(gmf)) # returns the overall fitted values in link scale
str(predict(gmf, type = "response")) # returns the overall fitted values in response scale
str(predict(gmf, type = "terms")) # returns the partial fitted values in link scale
str(predict(gmf, newY = newY)) # returns the predictions for the new set of responses

}
