% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_growth_model.R
\name{Markovmoments}
\alias{Markovmoments}
\title{Markovmoments}
\usage{
Markovmoments(states, ptm, ...)
}
\arguments{
\item{states}{A numerical vector with the states of the Markov process.}

\item{ptm}{The probability transition matrix, a square matrix of dimension length(states) whose columns sum to one.}

\item{...}{Additional arguments.}
}
\value{
It returns a list containing:
\item{Expectation }{The mean of the process.}
\item{Variance }{The variance of the process.}
\item{Autocovariance }{The autocovariance of the process.}
\item{Autocorrelation }{The autocorrelation of the process.}
\item{Stationary distribution }{The stationary distribution of the process, used for the computation of the moments.}
}
\description{
The function \code{Markovmoments} computes the expectation, variance, autocovariance and autocorrelation of a Markov process.
}
\examples{
a <- c(-1, 1)
A <- matrix(c(0.5, 0.6,
              0.5, 0.4), 2, 2)
Markovmoments(a, A)
}
